﻿using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;

namespace PpmsDataWebService.Models
{
    public class Facility
    {
        public string Name { get; set; }

        [Key]
        public string StationNumber { get; set; }    
        
        public string StationName { get; set; }

        public string FacilityName { get; set; }
      
        public FacilityType FacilityType { get; set; }

        public string Address1 { get; set; }

        public string Address2 { get; set; }

        public string Address3 { get; set; }

        public string City { get; set; }

        public string State { get; set; }

        public string ZipCode { get; set; }

        public string RegionName { get; set; }

        public string VisnName { get; set; }

        public virtual IQueryable<Visn> Visn { get; set; }

        public virtual IQueryable<Facility> ParentStation { get; set; }

        public virtual IQueryable<Facility> Facilities { get; set; }

        public virtual IQueryable<CareSite> CareSites { get; set; }

        public virtual IQueryable<Provider> Providers { get; set; }


    }
}